#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifdef BUILD_HIK_PRODUCT
#include <string>

#include "dllexport.h"
using namespace std;
typedef struct
{
	LONG     lUserID;
	LONG     AlarmType;
	char     sDeviceName[128];
	char     sDeviceIP[128];
} ALARMINFO;



typedef void (CALLBACK* fExceptionCallBack)(DWORD dwType, LONG lUserID, LONG lHandle, void *pUser);
typedef void (CALLBACK *fGetAlarmSrcInfoByUserID)(LONG lUserID, string& devName, string& userName);
typedef void (CALLBACK *fGetAlarmSrcInfoByIP)(char *deviceIP, string& devName, string& userName);
typedef void (CALLBACK* fShowLog)(char *log);
typedef BOOL (CALLBACK* fWriteLog2DB)();
typedef void (CALLBACK* HandleMessage)();
typedef void (CALLBACK* HandleException)();



class DLLAPI CHKGlobal 
{
public:
    CHKGlobal();
    ~CHKGlobal();
    static BOOL Startup();
    static BOOL Cleanup();
    static BOOL StartListen(char *sLocalIP, WORD wLocalPort, void *pUserData);
    static BOOL StopListen();
    static BOOL EnableLog2File(BOOL bLogEnable, char *strLogDir, BOOL bAutoDel);
	static void RegisterGetAlarmSrcInfoByUserID(fGetAlarmSrcInfoByUserID cb);
	static void RegisterGetAlarmSrcInfoByIP(fGetAlarmSrcInfoByIP cb);
    static void RegisterAlarmCallback(void* alarmCallBack, void* userParams);
    static BOOL SetExceptionCallBack();
	static void ShowLog(char *log);
	static void WriteLog2DB();
	ProcessAlarm();
private:
    static LONG m_lListenHandle;
	static fShowLog *m_cbShowLog;
	static fGetAlarmSrcInfoByUserID *m_cbGetAlarmSrcInfoByUserID;
	static fGetAlarmSrcInfoByIP *m_cbGetAlarmSrcInfoByIP;
	static fWriteLog2DB *m_cbWriteLog2DB;

};

#endif